// Mips software symbol table format definitions

#define stNil		0	/* mips asm guide page 11-17 */
#define stGlobal	1
#define stStatic	2
#define stParam		3
#define stLocal		4
#define stLabel		5
#define stProc		6
#define stBlock		7
#define stEnd		8
#define stMember	9
#define stTypedef	10
#define stFile		11
#define stRegReloc	12
#define stForward	13
#define stStaticProc	14
#define stConstant	15
#define stStruct	26
#define stUnion		27
#define stEnum		28

#define scNil		0	/* mips asm guide page 11-18 */
#define scText		1	/* text symbol */
#define scData		2	/* initialized data symbol */
#define scBss		3	/* un-initialized data symbol */
#define scRegister	4	/* value of symbol is register number */
#define scAbs		5	/* value of symbol is absolute */
#define scUndefined	6	/* who knows? */
#define scCdbLocal	7	/* variable's value is IN se->va.?? */
#define scBits		8	/* this is a bit field */
#define scCdbSystem	9	/* variable's value is IN CDB's address space*/
#define scDbx		9	/* overlap dbx internal use */
#define scRegImage	10	/* register value saved on stack */
#define scInfo		11	/* symbol contains debugger information */
#define scUserStruct	12	/* address in struct user for current process*/
#define scSData		13	/* load time only small data */
#define scSBss		14	/* load time only small common */
#define scRData		15	/* load time only read only data */
#define scVar		16	/* Var parameter (fortran,pascal) */
#define scCommon	17	/* common variable */
#define scSCommon	18	/* small common */
#define scVarRegister	19	/* Var parameter in a register */
#define scVariant	20	/* Variant record */
#define scSUndefined	21	/* small undefined(external) data */
#define scInit		22	/* .init section symbol */
#define scMax		32

#define btNil		0	/* mips asm guide page 11-21 */
#define btAdr		1	/* address - integer same size as pointer */
#define btChar		2	/* character */
#define btUChar		3	/* unsigned character */
#define btShort		4	/* short */
#define btUShort	5	/* unsigned short */
#define btInt		6	/* int */
#define btUInt		7	/* unsigned int */
#define btLong		8	/* long */
#define btULong		9	/* unsigned long */
#define btFloat		10	/* float (real) */
#define btDouble	11	/* Double (real) */
#define btStruct	12	/* Structure (Record) */
#define btUnion		13	/* Union (variant) */
#define btEnum		14	/* Enumerated */
#define btTypedef	15	/* defined via a typedef, isymRef points */
#define btRange		16	/* subrange of int */
#define btSet		17	/* pascal sets */
#define btComplex	18	/* fortran complex */
#define btDComplex	19	/* fortran double complex */
#define btIndirect	20	/* forward or unnamed typedef */
#define btMax		64

#define tqNil	0	/* mips asm guide page 11-21 */
#define tqPtr	1	/* pointer */
#define tqProc	2	/* procedure */
#define tqArray 3	/* duh */
#define tqFar	4	/* longer addressing - 8086/8 land */
#define tqVol	5	/* volatile */
#define tqMax	8

class FileHdr {				// mips asm guide page 10-5
public:
	unsigned short	magic;		// magic number
	unsigned short	nscns;		// number of sections
	long		timdat;		// time & date stamp
	long		symptr;		// file pointer to symbolic header
	long		nsyms;		// sizeof(symbolic hdr)
	unsigned short	opthdr;		// sizeof(optional hdr)
	unsigned short	flags;		// flags
};

class OptHdr {			// mips asm guide page 10-7
public:
	short	magic;		// see above
	short	vstamp;		// version stamp
	long	tsize;		// text size in bytes, padded to DW bdry
	long	dsize;		// initialized data "  "
	long	bsize;		// uninitialized data "   "
	long	entry;		// entry pt
	long	text_start;	// base of text used for this file
	long	data_start;	// base of data used for this file
	long	bss_start;	// base of bss used for this file
	long	gprmask;	// general purpose register mask
	long	cprmask[4];	// co-processor register masks
	long	gp_value;	// the gp value used for this object
};

class Section {			// mips asm guide page 10-8
public:
	char		name[8];
	long		paddr;
	long		vaddr;
	long		size;
	long		scnptr;
	long		relptr;
	long		lnnoptr;
	unsigned short	nreloc;
	unsigned short	nlnno;
	long		flags;
};

class LocSym {			// mips asm guide page 11-14
public:
	char	*iss;		// index into String Space of name [WAS LONG]
	long	value;		// value of symbol
	long	bits;
	unsigned st()    { return (bits>>26)&0x3F; }; //: 6 symbol type
	unsigned sc()    { return (bits>>21)&0x1F; }; //: 5 storage class
						      //: 1 reserved
	unsigned index() { return  bits & 0xFFFFF; }; //: 20 into sym/aux table
	int	isreg()	 { return sc() == scRegister; }
	void	init(long);
};

class ExtSym {				// mips asm guide page 11-23
public:
	short	reserved;
	short	ifd;
	LocSym	locsym;
	void	init(long);
};

class AuxSym {				// mips asm guide page 11-19
public:
	long	bits;							
	long	bt()	  { return (bits>>24)&0x3F; };	// base type
	long	tq(int i) { return (bits>>(12-4*i))&0xF; }; // type qualifier
	long	rfd()     { return (bits>>20)&0xFFF; };	// rel file desc
	long	index()   { return bits&0xFFFFF; };	// rel index
	int	isbitfield() { return bits&0x80000000; }
	int	pccbt();				// pcc's bt code
	int	pcctq(int);				// pcc's tq code
	int	dnHigh()  { return bits; };		// array bound
};

class SymHdr {			// mips asm guide page 11-8
public:
	short	magic;		// to verify validity of the table
	short	vstamp;		// version stamp
	long	ilineMax;	// number of line number entries
	long	cbLine;		// number of bytes for line number entries
	long	cbLineOffset;	// offset to start of line number entries
	long	idnMax;		// max index into dense number table
	long	cbDnOffset;	// offset to start dense number table
	long	ipdMax;		// number of procedures
	long	cbPdOffset;	// offset to procedure descriptor table
	long	isymMax;	// number of local symbols
	long	cbSymOffset;	// offset to start of local symbols
	long	ioptMax;	// max index into optimization symbol entries
	long	cbOptOffset;	// offset to optimization symbol entries
	long	iauxMax;	// number of auxillary symbol entries
	long	cbAuxOffset;	// offset to start of auxillary symbol entries
	long	issMax;		// max index into local strings 
	long	cbSsOffset;	// offset to start of local strings
	long	issExtMax;	// max index into external strings
	long	cbSsExtOffset;	// offset to start of external strings
	long	ifdMax;		// number of file descriptor entries
	long	cbFdOffset;	// offset to file descriptor table
	long	crfd;		// number of relative file descriptor entries
	long	cbRfdOffset;	// offset to relative file descriptor table
	long	iextMax;	// max index into external symbols
	long	cbExtOffset;	// offset to start of external symbol entries
	long	tablesize()	// of cbLineOffset thru end, in bytes
		 { return cbExtOffset-cbLineOffset+iextMax*sizeof(ExtSym); } 
};

class FileDesc {			// mips asm guide page 11-22
public:
	unsigned long	adr;	// memory address of beginning of file
	long	rss;		// file name (of source, if known)
	char	*issBase;	// file's string space		[WAS LONG]
	long	cbSs;		// number of bytes in the ss
	LocSym	*isymBase;	// beginning of symbols		[WAS LONG]
	long	csym;		// count file's of symbols
	long	ilineBase;	// file's line symbols			BOGUS
	long	cline;		// count of file's line symbols		BOGUS
	long	ioptBase;	// file's optimization entries
	long	copt;		// count of file's optimization entries
	short	ipdFirst;	// start of procedures for this file
	short	cpd;		// count of procedures for this file
	AuxSym	*iauxBase;	// file's auxiliary entries	[WAS LONG]
	long	caux;		// count of file's auxiliary entries
	long	*rfdBase;	// index into the file indirect table[WAS LONG]
	long	crfd;		// count file indirect entries

	unsigned lang: 5;	// language for this file
	unsigned fMerge : 1;	// whether this file can be merged
	unsigned fReadin : 1;	// true if it was read in (not just created)
	unsigned fBigendian : 1; // if set, was compiled on big endian machine
				//	aux's will be in compile host's sex
	unsigned glevel : 2;	// level this file was compiled with
	unsigned reserved : 22; // reserved for future use

	char	*cbLineOffset;	// byte offset from header lns	[WAS LONG]
	long	cbLine;		// size of lines for this file
	void	init(class MipsSymTab*);
class	Source	*src(MipsSymTab*, Source*);
};

class ProcDesc {		// mips asm guide page 11-13
public:
	unsigned long	adr;	// memory address of start of procedure BOGUS
	long	isym;		// start of local symbol entries
	long	ilineMax;	// start of line number entries	[WAS BOGUS]
	long	regmask;	// save register mask
	long	regoffset;	// save register offset
	long	iopt;		// start of optimization symbol entries
	long	fregmask;	// save floating point register mask
	long	fregoffset;	// save floating point register offset
	long	frameoffset;	// frame size
	short	framereg;	// frame pointer register
	short	pcreg;		// offset or reg of return pc
	long	lnLow;		// lowest line in the procedure
	long	lnHigh;		// highest line in the procedure
	char	*cbLineOffset;	// byte offset from the fd base [WAS LONG]
	void	init(FileDesc*);
};
